using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        int N;
        N = int.Parse(Console.ReadLine());
        List<int>[] graph = new List<int>[N + 1];
        for (int i = 1; i <= N; i++)
        {
            graph[i] = new List<int>();
        }
        for (int i = 1; i < N; i++)
        {
            int[] uv = Console.ReadLine().Split().Select(int.Parse).ToArray();
            graph[uv[0]].Add(uv[1]);
            graph[uv[1]].Add(uv[0]);
        }
        int[] platforms = Console.ReadLine().Split().Select(int.Parse).ToArray();
        int[] changes = Console.ReadLine().Split().Select(int.Parse).ToArray();
        int[] result = new int[N];
        int[] jumps = new int[N + 1];
        int[] states = new int[N + 1];
        DFS(1, 0, graph, platforms, changes, result, jumps, states);
        Console.WriteLine(string.Join(" ", result));
    }

    static void DFS(int node, int parent, List<int>[] graph, int[] platforms, int[] changes, int[] result, int[] jumps, int[] states)
    {
        states[node] = changes[node - 1];
        result[node - 1] = jumps[node] + states[node];
        foreach (int neighbor in graph[node])
        {
            if (neighbor != parent)
            {
                jumps[neighbor] = jumps[node] + 1;
                states[neighbor] = Math.Max(states[node] - 1, platforms[neighbor]);
                DFS(neighbor, node, graph, platforms, changes, result, jumps, states);
            }
        }
    }
}